


<?php $__env->startSection('title'); ?>
    <?php echo e(trans('general.import-history')); ?>

    <?php echo \Illuminate\View\Factory::parentPlaceholder('title'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header_right'); ?>
    <a href="<?php echo e(route('hardware.index')); ?>" class="btn btn-default"> <?php echo e(trans('general.back')); ?></a>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>


    <?php if(isset($status)): ?>

        <?php if(count($status['error']) > 0): ?>
            <div class="row">
                <div class="col-md-8 col-md-offset-2">
                    <div class="box box-default">
                        <div class="alert alert-danger">
                            <i class="fas fa-exclamation-triangle faa-pulse animated"></i>
                            <strong><?php echo e(count($status['error'])); ?> <?php echo e(trans('admin/hardware/general.error_messages')); ?></strong> </strong>
                            <?php echo e(trans('admin/hardware/general.alert_details')); ?>

                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <div class="row">
            <div class="col-md-8 col-md-offset-2">
                <div class="box box-default">
                    <div class="alert alert-success">
                        <i class="fas fa-check faa-pulse animated"></i>
                        <strong><?php echo e(count($status['success'])); ?> <?php echo e(trans('admin/hardware/general.success_messages')); ?> </strong>
                        <?php echo e(trans('admin/hardware/general.alert_details')); ?>

                    </div>
                </div>
            </div>
        </div>

        <?php endif; ?>

        <div class="row">
            <div class="col-md-8 col-md-offset-2">
                <div class="box box-default">
                    <div class="box-body">
                        <form class="form-horizontal" role="form" method="post" enctype="multipart/form-data" action="">
                            <!-- CSRF Token -->
                            <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>" />

                        <div class="col-md-12">
                            <?php if(Session::get('message')): ?>
                                <p class="alert-danger">
                                    <?php echo e(trans('admin/hardware/general.csv_error')); ?><br />
                                    <?php echo e(Session::get('message')); ?>

                                </p>
                            <?php endif; ?>
                        </div>
                        <div class="col-md-12" style="padding: 10px;">
                            <?php echo trans('admin/hardware/general.import_text'); ?>

                        </div>

                        <div class="col-md-12" style="padding: 10px;">
                            <div class="form-group">
                                <div class="col-md-9 col-md-offset-2">

                                    <label class="btn btn-default" aria-hidden="true">
                                        <?php echo e(trans('button.select_file')); ?>

                                        <input type="file" name="user_import_csv" class="js-uploadFile" id="uploadFile" data-maxsize="user_import_csv" accept=".csv,.xls,.xlsx,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/vnd.ms-excel,text/plain" style="display:none; max-width: 90%" aria-label="user_import_csv" aria-hidden="true"<?php echo e((config('app.lock_passwords')===true) ? ' disabled' : ''); ?>>
                                    </label>
                                    <span class="label label-default" id="uploadFile-info" style="font-size: 15px;"></span>

                                    <?php if(config('app.lock_passwords')===true): ?>
                                        <p class="text-warning"><i class="fas fa-lock"></i>
                                            <?php echo e(trans('general.feature_disabled')); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <!-- Match firstname.lastname -->
                            <div class="form-group">
                                <div class="col-sm-10 col-md-offset-2">
                                    <label class="form-control">
                                        <?php echo e(Form::checkbox('match_firstnamelastname', '1', old('match_firstnamelastname'))); ?>

                                        <!-- enclosing span needed for the checkbox CSS to work properly, since there's HTML in the label text -->
                                        <span>
                                            <?php echo trans('admin/hardware/general.csv_import_match_f-l'); ?>

                                        </span>
                                    </label>
                                </div>
                            </div>

                            <!-- Match flastname -->
                            <div class="form-group">
                                <div class="col-sm-10 col-md-offset-2">
                                    <label class="form-control">
                                        <?php echo e(Form::checkbox('match_flastname', '1', old('match_flastname'))); ?>

                                        <!-- enclosing span needed for the checkbox CSS to work properly, since there's HTML in the label text -->
                                        <span>
                                        <?php echo trans('admin/hardware/general.csv_import_match_initial_last'); ?>

                                        </span>
                                    </label>
                                </div>
                            </div>

                            <!-- Match firstname -->
                            <div class="form-group">
                                <div class="col-sm-10 col-md-offset-2">
                                    <label class="form-control">
                                    <?php echo e(Form::checkbox('match_firstname', '1', old('match_firstname'))); ?>

                                        <!-- enclosing span needed for the checkbox CSS to work properly, since there's HTML in the label text -->
                                        <span>
                                            <?php echo trans('admin/hardware/general.csv_import_match_first'); ?>

                                        </span>
                                    </label>
                                </div>
                            </div>

                            <!-- Match email -->
                            <div class="form-group">
                                <div class="col-sm-10 col-md-offset-2">
                                    <label class="form-control">
                                        <?php echo e(Form::checkbox('match_email', '1', old('match_email'))); ?>

                                        <!-- enclosing span needed for the checkbox CSS to work properly, since there's HTML in the label text -->
                                        <span>
                                        <?php echo trans('admin/hardware/general.csv_import_match_email'); ?>

                                        </span>
                                    </label>
                                </div>
                            </div>

                            <!-- Match username -->
                            <div class="form-group">
                                <div class="col-sm-10 col-md-offset-2">
                                    <label class="form-control">
                                        <?php echo e(Form::checkbox('match_username', '1', old('match_username'))); ?>

                                        <!-- enclosing span needed for the checkbox CSS to work properly, since there's HTML in the label text -->
                                        <span>
                                            <?php echo trans('admin/hardware/general.csv_import_match_username'); ?>

                                        </span>
                                    </label>
                                </div>
                            </div>


                        <!-- Form Actions -->
                        <div class="box-footer text-right">
                            <?php if(config('app.lock_passwords')===true): ?>
                                <div class="col-md-12">
                                    <div class="callout callout-info">
                                        <?php echo e(trans('general.feature_disabled')); ?>

                                    </div>
                                </div>

                            <?php else: ?>
                                <button type="submit" class="btn btn-default"><?php echo e(trans('button.submit')); ?></button>
                            <?php endif; ?>
                        </div>

            </form>

        </div>

<?php if(isset($status)): ?>


<?php if(count($status['error']) > 0): ?>
<div class="row">
    <div class="col-md-12">
        <div class="box box-default">
            <div class="box-header with-border">
                <h2 class="box-title"> <?php echo e(count($status['error'])); ?> <?php echo e(trans('admin/hardware/general.error_messages')); ?> </h2>
            </div>
            <div class="box-body">
                <div style="height : 400px; overflow : auto;">
                    <table class="table">
                        <?php for($x = 0; $x < count($status['error']); $x++): ?>
                            <?php $__currentLoopData = $status['error'][$x]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $object_type => $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="danger">
                                <td><strong><?php echo e(ucwords($object_type)); ?> <?php echo e(key($message)); ?>:</strong></td>
                                <td><?php echo e($message[key($message)]['msg']); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endfor; ?>
                    </table>
               </div>
            </div>
        </div>
    </div>
</div>

<?php endif; ?>

<?php if(count($status['success']) > 0): ?>
<div class="row">
    <div class="col-md-12">
        <div class="box box-default">
            <div class="box-header with-border">
                <h2 class="box-title"> <?php echo e(count($status['success'])); ?> <?php echo e(trans('admin/hardware/general.success_messages')); ?> </h2>
            </div>
            <div class="box-body">
                <div style="height : 400px; overflow : auto;">
                    <table class="table">
                        <?php for($x = 0; $x < count($status['success']); $x++): ?>
                            <?php $__currentLoopData = $status['success'][$x]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $object_type => $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="success">
                                    <td><strong><?php echo e(ucwords($object_type)); ?> <?php echo e(key($message)); ?>:</strong></td>
                                    <td><?php echo e($message[key($message)]['msg']); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endfor; ?>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>
<?php endif; ?>

</div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\it\resources\views/hardware/history.blade.php ENDPATH**/ ?>